package unitTest;

import org.junit.Test;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;

import netsdk.lib.CommonFunctions;
import netsdk.lib.DeviceSdk;
import netsdk.struct.DD_SMART_VFD_CONFIG;
import netsdk.struct.LPNET_SDK_DEVICEINFO;

public class NET_SDK_DVRConfig_Test {
	
	@Test
	public void NET_SDK_GetDVRConfig_Test() throws Throwable{
		Boolean initResult = CommonFunctions.init();
		if(!initResult)
			return;
		
		LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
		NativeLong lUserID = CommonFunctions.login(lpDeviceInfo);
		int num = lpDeviceInfo.videoInputNum;//通道最大数量
		
		DD_SMART_VFD_CONFIG[] sOut = new DD_SMART_VFD_CONFIG[num];
	    for (int i = 0; i < num; i++) {
	        sOut[i] = new DD_SMART_VFD_CONFIG();
	    }
	    Memory lpOutBuffer = new Memory(num * 32);
	        
		Memory lpBytesReturned = new Memory(4);
		NativeLong lChannel = new NativeLong(0xFFFFFFFF);
        boolean bResult = DeviceSdk.INSTANCE.NET_SDK_GetDVRConfig(lUserID, 0x1001,lChannel, lpOutBuffer, (int) lpOutBuffer.size(), lpBytesReturned, false);
        if (!bResult) {
            throw new RuntimeException("NET_SDK_GetDVRConfig 错误:" + CommonFunctions.getError());
        }
        
        CommonFunctions.GetPointerDataToStructArr(lpOutBuffer, sOut);
        for (int i = 0; i < num; i++) {
        	if(sOut[i].iSize>0){
	            System.out.println(String.format("获取数据==> iSize：%s", sOut[i].iSize));
	            Pointer p = sOut[i].getPointer();
				Native.free(Pointer.nativeValue(p));//手动释放内存  
				Pointer.nativeValue(p, 0);
        	}
        }
        
        Native.free(Pointer.nativeValue(lpOutBuffer));//手动释放内存  
		Pointer.nativeValue(lpOutBuffer, 0);
		
		Native.free(Pointer.nativeValue(lpBytesReturned));//手动释放内存  
		Pointer.nativeValue(lpBytesReturned, 0);
        
	}
	
	public DD_SMART_VFD_CONFIG[] NET_SDK_GetDVRConfig(NativeLong lUserID,int num) throws Throwable{
		
		DD_SMART_VFD_CONFIG[] sOut = new DD_SMART_VFD_CONFIG[num];
	    for (int i = 0; i < num; i++) {
	        sOut[i] = new DD_SMART_VFD_CONFIG();
	    }
	    Memory lpOutBuffer = new Memory(num * 32);
		
		Memory lpBytesReturned = new Memory(4);
		NativeLong lChannel = new NativeLong(0xFFFFFFFF);
        boolean bResult = DeviceSdk.INSTANCE.NET_SDK_GetDVRConfig(lUserID, 0x1001,lChannel, lpOutBuffer, (int) lpOutBuffer.size(), lpBytesReturned, false);
        if (!bResult) {
            throw new RuntimeException("NET_SDK_GetDVRConfig 错误:" + CommonFunctions.getError());
        }
        
        CommonFunctions.GetPointerDataToStructArr(lpOutBuffer, sOut);
        for (int i = 0; i < num; i++) {
        	if(sOut[i].iSize>0){
	            System.out.println(String.format("获取数据==> iSize：%s", sOut[i].iSize));
        	}
        }
        Native.free(Pointer.nativeValue(lpOutBuffer));//手动释放内存  
  		Pointer.nativeValue(lpOutBuffer, 0);
      		
  		Native.free(Pointer.nativeValue(lpBytesReturned));//手动释放内存  
  		Pointer.nativeValue(lpBytesReturned, 0);
        return sOut;
	}
	
	
	
	@Test
	public void NET_SDK_SetDVRConfig_Test() throws Throwable{
		Boolean initResult = CommonFunctions.init();
		if(!initResult)
			return;
		
		LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
		NativeLong lUserID = CommonFunctions.login(lpDeviceInfo);
		
		int num = lpDeviceInfo.videoInputNum;//通道最大数量
		DD_SMART_VFD_CONFIG[] sOut = NET_SDK_GetDVRConfig(lUserID,num);
		DD_SMART_VFD_CONFIG sIn = sOut[3];
		
		
		Memory lpInBuffer = new Memory(sIn.size());
		CommonFunctions.SetStructDataToPointer(sIn, lpInBuffer, 0);
	        
		NativeLong lChannel = new NativeLong(1);
        boolean bResult = DeviceSdk.INSTANCE.NET_SDK_SetDVRConfig(lUserID, 0x1001, lChannel, lpInBuffer, (int) lpInBuffer.size());
        if (!bResult) {
            throw new RuntimeException("NET_SDK_SetDVRConfig 错误:" + CommonFunctions.getError());
        }
       
        Native.free(Pointer.nativeValue(lpInBuffer));//手动释放内存  
		Pointer.nativeValue(lpInBuffer, 0);
		
		for (int i = 0; i < num; i++) {
			Pointer p = sOut[i].getPointer();
			Native.free(Pointer.nativeValue(p));//手动释放内存  
			Pointer.nativeValue(p, 0);
	    }
	}

}
